/*******************************************************
Filename		:  di_activity_matrix.sql
Release 		:  c2.0
SIR			:  1499
Description		:  Creates the dimension table DI_ACTIVITY_MATRIX and related objects.
Author			:  Thieu Nguyen
Date			:  7/16/2003
Comments		:  
**********************************************************/

connect storetw/storetw@storet.sdc
spool di_activity_matrix.log

drop sequence seq_activity_matrix;

create sequence seq_activity_matrix
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_activity_matrix;
create table di_activity_matrix
(PK_ISN number(12),
 MATRIX_CODE char(4),
 MATRIX_NAME varchar2(25),
 MATRIX_DESCRIPTION VARCHAR2(120))
tablespace storetdata
storage (initial 256K next 256K)
nologging;

alter table di_activity_matrix
add constraint pk_di_activity_matrix primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128K next 128K);

--add data to di_activity_matrix
set serveroutput on
declare
cursor c1 is SELECT CODE, NAME, DESCRIPTION FROM storet.TSRMATRX
where name in (select distinct activity_matrix from fa_regular_result
		where activity_matrix is not null);

begin
for c1_var in c1 loop
insert into di_activity_matrix(PK_ISN,MATRIX_CODE, MATRIX_NAME, MATRIX_DESCRIPTION)
values(seq_activity_matrix.nextval,c1_var.CODE, c1_var.NAME, c1_var.DESCRIPTION);
end loop;
commit;
end;
/

--update fks in FA_REGULAR_RESULT
declare
cursor c1 is select * from di_activity_matrix;

begin
for c1_var in c1 loop
update FA_REGULAR_RESULT
set FK_ACT_MATRIX = c1_var.pk_isn
where ACTIVITY_MATRIX = c1_var.MATRIX_NAME
  and ACTIVITY_MATRIX is not null;
commit;
end loop;
commit;
end;
/
spool off;